/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.particle.packs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.redpxnda.respawnobelisks.config.ChargeConfig;
import com.redpxnda.respawnobelisks.config.CurseConfig;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public interface IBasicPack {
    default public void depleteAnimation(Level level, @Nullable Player player, BlockPos blockPos) {
    }

    default public void chargeAnimation(Level level, @Nullable Player player, BlockPos blockPos) {
    }

    default public void chargeServerHandler(ServerLevel level, ServerPlayer player, BlockPos blockPos) {
    }

    default public void depleteServerHandler(ServerLevel level, ServerPlayer player, BlockPos blockPos) {
    }

    default public void curseServerHandler(ServerLevel level, ServerPlayer player, BlockPos blockPos) {
    }

    default public void curseAnimation(Level level, @Nullable Player player, BlockPos blockPos) {
        for (int i = 0; i < 360; i += 3) {
            double radians = (double)i * Math.PI / 180.0;
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50451_.m_49966_()), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.65, (double)blockPos.m_123343_() + 0.5, Math.sin(radians) / 1.5, 0.25, Math.cos(radians) / 1.5);
        }
    }

    default public SoundEvent depleteSound() {
        Optional sound = Registry.f_122821_.m_6612_(new ResourceLocation(ChargeConfig.obeliskDepleteSound));
        return sound.orElse(SoundEvents.f_12490_);
    }

    default public SoundEvent chargeSound() {
        Optional sound = Registry.f_122821_.m_6612_(new ResourceLocation(ChargeConfig.obeliskChargeSound));
        return sound.orElse(SoundEvents.f_12490_);
    }

    default public SoundEvent curseSound() {
        Optional sound = Registry.f_122821_.m_6612_(new ResourceLocation(CurseConfig.curseSound));
        return sound.orElse(SoundEvents.f_12490_);
    }

    default public float depleteSoundVolume() {
        return 1.0f;
    }

    default public float chargeSoundVolume() {
        return 1.0f;
    }

    default public float curseSoundVolume() {
        return 1.0f;
    }

    default public float depleteSoundPitch() {
        return 1.0f;
    }

    default public float chargeSoundPitch() {
        return 1.0f;
    }

    default public float curseSoundPitch() {
        return 1.0f;
    }

    default public float[] runeColor(float partialTick, Level level) {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    default public boolean obeliskRenderTick(RespawnObeliskBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        return false;
    }
}

